/*
 * sct_ws2811.h
 *
 *  Created on: 09.09.2014
 *      Author: nxp75900
 */

#ifndef SCT_WS2811_H_
#define SCT_WS2811_H_
#include "board.h"

#define DATA_OUT          5                               // use SCT1_OUT0 as data output
#define AUX_OUT           4                               // use SCT1_OUT1 as aux output
#define DATA_SPEED        800000

#define WS2811_FB         (100000000/DATA_SPEED)    // full data bit time   = 125 (at 800 kb/s)
#define WS2811_T0H        ((WS2811_FB* 15)/100)            // data bit 0 high time ~ 19 (at 800 kb/s)
#define WS2811_T1H        ((WS2811_FB*35)/100)            // data bit 1 high time ~ 43 (at 800 kb/s)

#ifdef __cplusplus
extern "C" {
#endif

void LEDDRIVER_open(void);
void LEDDRIVER_write(uint32_t rgb);                // write frame
void LEDDRIVER_haltAfterFrame(int on);             // (de)activate HALT after next frame
void LEDDRIVER_start(void);                        // start a transmission

#ifdef __cplusplus
}
#endif



#endif /* SCT_WS2811_H_ */
